/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util;

import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.persistence.EstadoNFe;
import java.rmi.RemoteException;
import java.util.Hashtable;

public class GerenciadorProxy {
    public static GerenciadorInterface gerenciador;

    public static void notificarNota(EstadoNFe nota) {
        try {
            gerenciador.atualizarNota(nota);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void notificarNotaConector(EstadoNFe nota) {
        try {
            gerenciador.notificarNotaConector(nota);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void notificarEventoCCe(String chave, String response) {
        try {
            gerenciador.notificarEventoCCe(chave, response);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void notificarLote(EstadoLote lote) {
        try {
            gerenciador.atualizarLote(lote);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static void notificarCaidaServicos() {
    }

    public static void notificarImpressao(String idNota, String estado, String xml, Hashtable<String, String> prop) {
        int pos1 = xml.indexOf("<NFref>");
        int pos2 = xml.indexOf("</NFref>");
        if (pos1 != -1 && pos2 != -1) {
            String nfref = xml.substring(pos1, pos2 + "</NFref>".length());
            xml = xml.replace(nfref, "");
        }
        try {
            gerenciador.imprimir(idNota, estado, xml, prop);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public static String enviarMensagemXML(String idServico, String cnpj, String cabecalho, String xml, String UF, String idUsuario) throws Exception {
        Hashtable<String, String> prop = new Hashtable<String, String>();
        prop.put("UF", UF);
        return gerenciador.enviarMensagemXML(idServico, cnpj, cabecalho, xml, prop, idUsuario);
    }

    public static GerenciadorInterface getGerenciador() {
        return gerenciador;
    }

    public static void setGerenciador(GerenciadorInterface gerenciador) {
        GerenciadorProxy.gerenciador = gerenciador;
    }
}

