/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util;

import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EstadoLote;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.EstadoNFeOld;
import br.com.taragona.nfe.persistence.db.QuickDB;
import br.com.taragona.nfe.util.ConfiguracaoSys;
import br.com.taragona.nfe.util.ExtrairNotasProtocolos;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.data.BaseDadosConfig;
import br.com.taragona.nfe.util.logger.LoggingJava;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;

public class LimparBancoDados {
    private DAOGenerico<EstadoNFe> dao = new DAOGenerico(EstadoNFe.class);
    private DAOGenerico<EstadoLote> daoLote = new DAOGenerico(EstadoLote.class);
    private ExtrairNotasProtocolos extrator = new ExtrairNotasProtocolos(null);
    private DAOGenerico<EstadoNFeOld> daoOld = new DAOGenerico(EstadoNFeOld.class);

    public void apagarTabelas() {
        BaseDadosConfig bd = PropriedadesSistema.getBdConfig();
        QuickDB q = new QuickDB(bd.getUrl(), bd.getUsuario(), bd.getSenha());
        try {
            q.limparTabela("LogNFe");
        }
        catch (Exception e) {
            LoggingJava.logger.log(Level.INFO, "Problemas eliminando tabela LogNFe", e);
        }
        try {
            q.limparTabela("EstadoNotaOld");
        }
        catch (Exception e) {
            LoggingJava.logger.log(Level.INFO, "Problemas eliminando tabela EstadoNotaOld", e);
        }
        try {
            q.limparTabela("EstadoRecibo");
        }
        catch (Exception e) {
            LoggingJava.logger.log(Level.INFO, "Problemas eliminando tabela EstadoRecibo", e);
        }
    }

    public void apagarLotes() {
        List<EstadoLote> lotes = this.daoLote.obterElementos();
        for (EstadoLote lote : lotes) {
            Set<EstadoNFe> notas = lote.getNotas();
            for (EstadoNFe nota : notas) {
                nota.setLote(null);
                this.dao.unir(nota);
            }
            this.daoLote.removerEntity(lote);
        }
    }

    public void apagarNotas() {
        List<EstadoNFe> notas = this.extrator.obterNotas();
        for (EstadoNFe nota : notas) {
            this.dao.removerEntity(nota);
        }
    }

    public void make() {
        try {
            this.apagarNotas();
        }
        catch (Exception e) {
            LoggingJava.logger.log(Level.INFO, "Problemas apagando notas", e);
        }
        this.apagarTabelas();
        try {
            this.apagarLotes();
        }
        catch (Exception e) {
            LoggingJava.logger.log(Level.INFO, "Problemas apagando lotes", e);
        }
    }

    public static void main(String[] args) {
        PropriedadesMain.processarComandos(args);
        BaseDadosConfig bd = new BaseDadosConfig();
        bd.setNomeDriver(ConfiguracaoSys.getDRIVER());
        bd.setUsuario(ConfiguracaoSys.getUSER_NAME());
        bd.setSenha(ConfiguracaoSys.getPASSWORD());
        bd.setUrl(ConfiguracaoSys.getURL_CONECTION());
        bd.setToplinkProp("update");
        PropriedadesSistema.setBdConfig(bd);
        LimparBancoDados limpar = new LimparBancoDados();
        limpar.make();
    }
}

