/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;

public class PrintFinder {
    private static PrintFinder instance = null;
    private String file = "impressoras.properties";
    private String fileList = "impressoras_permitidas.properties";
    private String notaList = "notaimpressoras.properties";
    private Hashtable<String, String> table;
    private Hashtable<String, String> notaimpressoras;

    public static PrintFinder getInstance() {
        if (instance == null) {
            instance = new PrintFinder();
        }
        return instance;
    }

    private PrintFinder() {
        String classpath = System.getProperty("java.class.path");
        String[] paths = classpath.split(";");
        String path = null;
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string.contains("conf")) {
                path = string;
                break;
            }
            ++n2;
        }
        this.file = String.valueOf(path) + "\\" + this.file;
        this.fileList = String.valueOf(path) + "\\" + this.fileList;
        this.notaList = String.valueOf(path) + "\\" + this.notaList;
        this.table = new Hashtable();
        this.notaimpressoras = new Hashtable();
        this.loadResource();
    }

    private void loadResource() {
        try {
            FileInputStream f = new FileInputStream(this.file);
            DataInputStream dis = new DataInputStream(f);
            String line = dis.readLine();
            while (line != null) {
                String[] parts = line.split("=");
                if (parts.length >= 2) {
                    this.table.put(parts[0].trim(), parts[1].trim());
                }
                line = dis.readLine();
            }
            dis.close();
            f.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadResourceImpressoras() {
        try {
            FileInputStream f = new FileInputStream(this.notaList);
            DataInputStream dis = new DataInputStream(f);
            String line = dis.readLine();
            while (line != null) {
                String[] parts = line.split("=");
                this.notaimpressoras.put(parts[0].trim(), parts[1].trim());
                line = dis.readLine();
            }
            dis.close();
            f.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void persistPrintKey(String id, String key) {
        this.notaimpressoras.put(id, key);
        try {
            FileWriter fw = new FileWriter(id, true);
            fw.write(String.valueOf(key) + "\n");
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String findPrint(String id) {
        String print = null;
        try {
            String key = this.notaimpressoras.get(id.trim());
            if (key == null) {
                FileInputStream f = new FileInputStream(id);
                DataInputStream dis = new DataInputStream(f);
                String line = dis.readLine();
                key = new String();
                while (line != null) {
                    key = String.valueOf(key) + line;
                    line = dis.readLine();
                }
                dis.close();
                f.close();
            }
            System.out.println("Find key:" + key);
            try {
                print = this.table.get(key.trim());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (print == null) {
                print = this.table.get("impressora_default");
            }
            return print;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (print == null) {
                print = this.table.get("impressora_default");
            }
            return print;
        }
    }

    public void setPrinter(String codigo, String printer) {
        this.loadResource();
        this.table.put(codigo, printer);
        try {
            FileWriter fw = new FileWriter(this.file);
            for (String codigo1 : this.table.keySet()) {
                fw.write(String.valueOf(codigo1) + "=" + this.table.get(codigo1) + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Hashtable<String, String> obterImpressorasDefault() {
        return this.table;
    }

    public Hashtable<String, String> obterImpressorasPermitidas() {
        Hashtable<String, String> tt = new Hashtable<String, String>();
        try {
            FileInputStream f = new FileInputStream(this.fileList);
            DataInputStream dis = new DataInputStream(f);
            String line = dis.readLine();
            while (line != null) {
                System.out.println(line);
                String[] parts = line.split("=");
                tt.put(parts[0].trim(), parts[1].trim());
                line = dis.readLine();
            }
            dis.close();
            f.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return tt;
    }

    public Vector<String> findPrinter() {
        PrintService[] ps;
        Vector<String> printers = new Vector<String>();
        PrintService[] printServiceArray = ps = PrintServiceLookup.lookupPrintServices(null, null);
        int n = ps.length;
        int n2 = 0;
        while (n2 < n) {
            PrintService print = printServiceArray[n2];
            printers.add(print.getName());
            ++n2;
        }
        return printers;
    }

    public static void main(String[] args) {
        String[] splits = "im=".split("=");
        System.out.println(splits[1]);
    }
}

