/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util;

import br.com.taragona.nfe.persistence.CodigoNFe;
import br.com.taragona.nfe.util.data.BaseDadosConfig;

public class PropriedadesSistema {
    private static final long serialVersionUID = 1L;
    public static CodigoNFe LOTE_RECEBIDO = new CodigoNFe(103, "Lote recebido com sucesso");
    public static CodigoNFe LOTE_PROCESSADO = new CodigoNFe(104, "Lote processado");
    public static CodigoNFe NOTA_AUTORIZADA = new CodigoNFe(100, "Autorizado o uso da NF-e");
    public static CodigoNFe NOTA_AUTORIZADA_FORA_PRAZO = new CodigoNFe(150, "Autorizado o uso da NF-e - autorizacao fora do prazo");
    public static CodigoNFe NOTA_CANCELADA = new CodigoNFe(101, "Cancelamento de NF-e homologado");
    public static CodigoNFe LIMITE_CANCELAMENTO = new CodigoNFe(220, "Rejeicao: NF-e autorizada ha mais de 60 dias");
    public static CodigoNFe JA_CANCELADA = new CodigoNFe(218, "218 = Rejeicao: NF-e ja esta cancelada na base de dados da SEFAZ");
    public static CodigoNFe NOTA_INUTILIZADA = new CodigoNFe(102, "Inutilizacao de numero homologado");
    public static CodigoNFe FALHA_ESQUEMA = new CodigoNFe(215, "Rejeicao: Falha no schema XML");
    public static CodigoNFe FALHA_ESQUEMA_NFE = new CodigoNFe(225, "Rejeicao: Falha no Schema XML da NFe");
    public static CodigoNFe XML_MAL_FORMADO = new CodigoNFe(243, "Rejeicao: XML Mal Formado");
    public static CodigoNFe DPEC_RECEBIDO = new CodigoNFe(124, "DPEC recebido pelo Sistema de Contingencia Eletronica");
    public static String ID_SERVICO_RECEPCAO = "Recepcao";
    public static String ID_SERVICO_RETRECEPCAO = "RetRecepcao";
    public static String ID_SERVICO_CONSULTA = "Consulta";
    public static String ID_SERVICO_RECEPCAO_EVENTO = "RecepcaoEvento";
    public static String ID_SERVICO_CANCELAMENTO = "Cancelamento";
    public static String ID_SERVICO_INUTILIZACAO = "Inutilizacao";
    public static String ID_SERVICO_ESTADO_SERVICOS = "StatusServicos";
    public static String ID_SERVICO_RECEPCAO_DPEC = "RecepcaoDPEC";
    public static String ID_SERVICO_CONSULTA_DPEC = "ConsultaDPEC";
    public static String ID_PRODUCAO = "producao";
    public static String ID_HOMOLOGACAO = "homologacao";
    public static String ID_LASER = "laser";
    public static String ID_SCAN = "scan";
    public static String ID_DPEC = "dpec";
    public static BaseDadosConfig bdConfig;

    public static BaseDadosConfig getBdConfig() {
        return bdConfig;
    }

    public static void setBdConfig(BaseDadosConfig bdConfig) {
        PropriedadesSistema.bdConfig = bdConfig;
    }

    public static boolean isCodigoAutorizado(int codigo) {
        return codigo == NOTA_AUTORIZADA.getId() || codigo == NOTA_AUTORIZADA_FORA_PRAZO.getId();
    }

    public static boolean isCodigoAutorizado(Long codigo) {
        return codigo != null && PropriedadesSistema.isCodigoAutorizado(codigo.intValue());
    }

    public static boolean isCodigoAutorizado(String codigo) {
        if (codigo == null) {
            return false;
        }
        try {
            return PropriedadesSistema.isCodigoAutorizado(Integer.parseInt(codigo.trim()));
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    public static enum ESTRATEGIA {
        TARAGONA,
        MANUAL_CONTINGENCIA;

    }

    public static enum MODO_OP {
        CONTINGENCIA,
        NORMAL,
        CONTINGENCIA_SCAN,
        LASER,
        CONTINGENCIA_DPEC,
        SVC_AN,
        SVC_RS,
        SVC_OUTRO,
        CONTINGENCIA_EPEC;

    }
}

