/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util.extract;

import br.com.taragona.nfe.clientreferencia.ReferenciaGerenciador;
import br.com.taragona.nfe.danfe.RepareProtocol;
import br.com.taragona.nfe.gerenciador.GerenciadorInterface;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.persistence.ExtraXMLInfo;
import br.com.taragona.nfe.tools.PathFileFinder;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.tti.util.CopyFile;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.Vector;

public class XMLFormer {
    private String tpAmb;
    private DAOGenerico<EstadoNFe> daoNFe;
    private ResourceBundle bundler;
    private String filename;
    private ThreadLocal<String> threadFilename = new ThreadLocal();
    private RepareProtocol repare;
    private DAOGenerico<ExtraXMLInfo> daoextraxml;
    private SimpleDateFormat dff = new SimpleDateFormat("dd_MM_yyyy");
    private SimpleDateFormat dffano = new SimpleDateFormat("yyyy");
    private SimpleDateFormat dffmes = new SimpleDateFormat("MMM_yyyy");
    private SimpleDateFormat dffdia = new SimpleDateFormat("dd_MMM");

    public XMLFormer(String tpAmb) {
        this.tpAmb = tpAmb;
        try {
            this.bundler = ResourceBundle.getBundle("pastas_cnpj");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.daoNFe = new DAOGenerico(EstadoNFe.class);
        this.daoextraxml = new DAOGenerico(ExtraXMLInfo.class);
        this.repare = new RepareProtocol();
    }

    public String getTpAmb() {
        return this.tpAmb;
    }

    public void setTpAmb(String tpAmb) {
        this.tpAmb = tpAmb;
    }

    public String getPath(String cnpj) {
        String path = null;
        if (this.bundler != null) {
            path = this.bundler.getString(cnpj);
            return path;
        }
        return null;
    }

    private void reprocessarNFe(EstadoNFe nota, String idUsuario) {
        GerenciadorInterface ger = null;
        try {
            ger = ReferenciaGerenciador.obterReferenciaGerenciador("localhost");
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        if (ger == null) {
            return;
        }
        if (nota.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ERRO_VALIDACAO) || nota.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.ERRO_ESQUEMA)) {
            return;
        }
        Vector<String> nfes = new Vector<String>();
        nfes.add(nota.getId());
        try {
            ger.checarConsistencia(nfes, nota.getAmbiente(), idUsuario);
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    private String repareProtocol(String xml) {
        xml = xml.replace("TProtNFe", "protNFe");
        xml = xml.replace("tProtNFe", "protNFe");
        xml = xml.replace("xmlns:ns2=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
        xml = xml.replace("ns2:", "");
        xml = xml.replace(":ns2", "");
        xml = xml.replace(" xmlns=\"http://www.w3.org/2000/09/xmldsig#\"", "");
        return xml;
    }

    public String getXML(String id, String tpAmb) {
        return this.getXML(id, tpAmb, null);
    }

    public String getXML(String id, String tpAmb, String idUsuario) {
        EntidadeId eid;
        EstadoNFe nota;
        if (!id.startsWith("NFe")) {
            id = "NFe" + id;
        }
        if ((nota = this.daoNFe.buscarPorIdObject(eid = new EntidadeId(id, tpAmb))) != null) {
            String xmlNota = nota.getXmlString();
            String xmlProtocol = nota.getProtocoloXML();
            if (xmlNota == null || xmlNota.isEmpty() || xmlProtocol == null || xmlProtocol.isEmpty()) {
                this.reprocessarNFe(nota, idUsuario);
                this.daoNFe.refresh(nota);
            }
            if (xmlNota == null || xmlNota.isEmpty() || xmlProtocol == null || xmlProtocol.isEmpty()) {
                return null;
            }
            xmlProtocol = this.repareProtocol(xmlProtocol);
            String xml = null;
            if (xmlNota.contains("versao=\"2.00\"")) {
                xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><nfeProc xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"2.00\">" + xmlNota + xmlProtocol + "</nfeProc>";
                this.repare.setVersao("2.00");
            } else {
                xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><nfeProc xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"4.00\">" + xmlNota + xmlProtocol + "</nfeProc>";
                this.repare.setVersao("4.00");
            }
            return xml;
        }
        System.out.println("Nota nao encontrada: " + id);
        return null;
    }

    public synchronized String createDenegadaFile(String id, String tpAmb, String cnpj, String file, Date dataGerada) {
        this.filename = null;
        this.threadFilename.remove();
        String xml = this.getXML(id, tpAmb);
        String path = "";
        if (this.bundler != null) {
            path = PathFileFinder.getINSTANCE().findXMLDenegadaPath(id, tpAmb, dataGerada);
            File f = new File(path);
            if (!f.exists()) {
                f.mkdirs();
            }
            file = String.valueOf(path) + "/" + file;
        }
        if (xml != null) {
            try {
                this.filename = file;
                this.threadFilename.set(file);
                xml = this.repare.repare(xml);
                id = id.startsWith("NFe") ? id : "NFe" + id;
                EntidadeId e_id = new EntidadeId(id, tpAmb);
                ExtraXMLInfo extrainfo = this.daoextraxml.buscarPorIdObject(e_id);
                if (extrainfo != null) {
                    String b2bxml = extrainfo.getXmlstring();
                    String nfexml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
                    b2bxml = b2bxml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
                    xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><nfeProcB2B>" + nfexml + b2bxml + "</nfeProcB2B>";
                }
                FileWriter fw = new FileWriter(file);
                fw.write(xml);
                fw.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    public synchronized String createFile(String id, String tpAmb, String cnpj, String file, Date dataGerada, boolean show) {
        return this.createFile(id, tpAmb, cnpj, file, dataGerada, show, null);
    }

    public synchronized String createFile(String id, String tpAmb, String cnpj, String file, Date dataGerada, boolean show, String idUsuario) {
        String original_file = file;
        final String original_tpAmb = tpAmb;
        final Date original_dataGerada = dataGerada;
        this.filename = null;
        this.threadFilename.remove();
        String xml = this.getXML(id, tpAmb, idUsuario);
        String path = "";
        String pathExtra = "";
        String fileExtra = "";
        if (this.bundler != null) {
            path = PathFileFinder.getINSTANCE().findXMLPath(id, tpAmb, dataGerada);
            pathExtra = PathFileFinder.getINSTANCE().findXMLPathExtra(id, tpAmb, dataGerada);
            File f = new File(path);
            if (!f.exists()) {
                f.mkdirs();
            }
            fileExtra = String.valueOf(pathExtra) + "/" + file;
            file = String.valueOf(path) + "/" + file;
        }
        if (xml != null) {
            try {
                FileWriter fw2;
                File f;
                String pathcfop;
                this.filename = file;
                this.threadFilename.set(file);
                xml = this.repare.repare(xml);
                id = id.startsWith("NFe") ? id : "NFe" + id;
                EntidadeId e_id = new EntidadeId(id, tpAmb);
                ExtraXMLInfo extrainfo = this.daoextraxml.buscarPorIdObject(e_id);
                if (extrainfo != null) {
                    String b2bxml = extrainfo.getXmlstring();
                    String nfexml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
                    b2bxml = b2bxml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
                    xml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><nfeProcB2B>" + nfexml + b2bxml + "</nfeProcB2B>";
                }
                FileWriter fw = new FileWriter(file);
                fw.write(xml);
                fw.close();
                if (show) {
                    File f2;
                    ResourceBundle rb;
                    try {
                        String caminho_amazon_olist;
                        rb = ResourceBundle.getBundle("olist");
                        if (rb != null && rb.containsKey("caminho_amazon_olist") && (caminho_amazon_olist = rb.getString("caminho_amazon_olist")) != null && !caminho_amazon_olist.trim().equals("")) {
                            f2 = new File(caminho_amazon_olist = caminho_amazon_olist.trim());
                            if (!f2.exists()) {
                                f2.mkdirs();
                            }
                            if (f2.exists()) {
                                FileWriter fwOlist = new FileWriter(new File(caminho_amazon_olist).getAbsoluteFile() + File.separator + original_file);
                                fwOlist.write(xml);
                                fwOlist.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    try {
                        String caminho_amazon_anymarket;
                        rb = ResourceBundle.getBundle("olist");
                        if (rb != null && rb.containsKey("caminho_amazon_anymarket") && (caminho_amazon_anymarket = rb.getString("caminho_amazon_anymarket")) != null && !caminho_amazon_anymarket.trim().equals("")) {
                            f2 = new File(caminho_amazon_anymarket = caminho_amazon_anymarket.trim());
                            if (!f2.exists()) {
                                f2.mkdirs();
                            }
                            if (f2.exists()) {
                                FileWriter fwAnymarket = new FileWriter(new File(caminho_amazon_anymarket).getAbsoluteFile() + File.separator + original_file);
                                fwAnymarket.write(xml);
                                fwAnymarket.close();
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (xml.contains("<CNPJ>09219242000145</CNPJ>") && (xml.contains("<CFOP>5102</CFOP>") || xml.contains("<CFOP>5114</CFOP>") || xml.contains("<CFOP>5403</CFOP>") || xml.contains("<CFOP>5557</CFOP>") || xml.contains("<CFOP>5910</CFOP>") || xml.contains("<CFOP>5912</CFOP>") || xml.contains("<CFOP>5914</CFOP>") || xml.contains("<CFOP>5917</CFOP>") || xml.contains("<CFOP>6102</CFOP>") || xml.contains("<CFOP>6108</CFOP>") || xml.contains("<CFOP>6114</CFOP>") || xml.contains("<CFOP>6403</CFOP>") || xml.contains("<CFOP>6557</CFOP>") || xml.contains("<CFOP>6910</CFOP>") || xml.contains("<CFOP>6912</CFOP>") || xml.contains("<CFOP>6917</CFOP>") || xml.contains("<CFOP>7102</CFOP>") || xml.contains("<CFOP>7949</CFOP>"))) {
                    pathcfop = PathFileFinder.getINSTANCE().findCFOPXML(id, tpAmb, dataGerada);
                    f = new File(pathcfop);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    fw2 = new FileWriter(String.valueOf(pathcfop) + File.separator + original_file);
                    fw2.write(xml);
                    fw2.close();
                }
                if (xml.contains("<CNPJ>54048228000180</CNPJ>") && (xml.contains("<CFOP>5905</CFOP>") || xml.contains("<CFOP>5934</CFOP>"))) {
                    pathcfop = PathFileFinder.getINSTANCE().findCFOPXML(id, tpAmb, dataGerada);
                    System.out.println("cnpj do destinat\u00c3\u00a1rio: 54048228000180");
                    System.out.println("Encontrado CFOP 5905 ou 5934");
                    System.out.println("caminho encontrado: " + pathcfop);
                    f = new File(pathcfop);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    System.out.println("caminho do xml da cfop: " + pathcfop + File.separator + original_file);
                    fw2 = new FileWriter(String.valueOf(pathcfop) + File.separator + original_file);
                    fw2.write(xml);
                    fw2.close();
                }
                if (xml.contains("<CNPJ>18132062000384</CNPJ>") && (xml.contains("<CFOP>5905</CFOP>") || xml.contains("<CFOP>5934</CFOP>"))) {
                    final String pathExtra2 = String.valueOf(PathFileFinder.getINSTANCE().findXMLPathExtra(id, tpAmb, dataGerada)) + "/Armazenagens";
                    f = new File(pathExtra2);
                    if (!f.exists()) {
                        f.mkdirs();
                    }
                    fw2 = new FileWriter(String.valueOf(pathExtra2) + File.separator + original_file);
                    fw2.write(xml);
                    fw2.close();
                    final String iii = id;
                    Thread t = new Thread(new Runnable(){

                        @Override
                        public void run() {
                            String srcPDF = XMLFormer.this.findPDF(iii, original_tpAmb, original_dataGerada);
                            CopyFile.copyfile(srcPDF, String.valueOf(pathExtra2) + "/" + iii + ".pdf");
                        }
                    });
                    t.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return path;
    }

    private String findPDF(String id, String tpAmb, Date dataGerada) {
        String path = String.valueOf(PathFileFinder.getINSTANCE().findPDFPath(id, tpAmb, dataGerada)) + "/";
        File f = new File(String.valueOf(path) + id + ".pdf");
        boolean finded = false;
        int i = 0;
        while (i < PropriedadesMain.getTimeout_email()) {
            long last;
            long currentTime;
            System.out.println("Procurando PDF!" + f.getAbsolutePath());
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (f.exists() && (currentTime = Calendar.getInstance().getTimeInMillis()) - (last = f.lastModified()) > 2000L) {
                finded = true;
                break;
            }
            ++i;
        }
        if (finded) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public String getFilename() {
        String threadFile = this.threadFilename.get();
        if (threadFile != null) {
            return threadFile;
        }
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }
}

