/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.util.importdata;

import br.com.taragona.nfe.classes.recepcao.TNFe;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.EnviarNota;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import javax.xml.bind.JAXBElement;

public class RestoreXML {
    private XMLGenerator gen = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
    private EntityManager daoTarget;
    private SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");

    private void createTarget() {
        ResourceBundle s = ResourceBundle.getBundle("target");
        HashMap<String, String> h = new HashMap<String, String>();
        h.put("javax.persistence.jdbc.password", s.getString("password"));
        h.put("javax.persistence.jdbc.user", s.getString("user"));
        h.put("javax.persistence.jdbc.url", s.getString("url"));
        h.put("javax.persistence.jdbc.driver", s.getString("driver"));
        h.put("eclipselink.ddl-generation", "create-or-extend-tables");
        EntityManagerFactory fact = Persistence.createEntityManagerFactory((String)"MessengerAPIPU2", h);
        this.daoTarget = fact.createEntityManager();
    }

    private void restore() {
        File[] files;
        this.createTarget();
        File dir = new File("E:\\Instala\u00e7oes de Clientes\\Racoes Reis\\XML\\XML");
        File[] fileArray = files = dir.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("prot.xml")) {
                try {
                    String xml = EnviarNota.lerArquivo(file.getAbsolutePath());
                    String prot = this.extractProt(xml);
                    xml = this.extractXml(xml);
                    JAXBElement nfe = (JAXBElement)this.gen.toObject(xml);
                    EstadoNFe estado = new EstadoNFe();
                    estado.setId(((TNFe)nfe.getValue()).getInfNFe().getId());
                    estado.setXmlString(xml);
                    estado.setEstado(EstadoNFe.ESTADO_NFE.AUTORIZADA);
                    Date d1 = this.df.parse(((TNFe)nfe.getValue()).getInfNFe().getIde().getDEmi().toString());
                    estado.setDataAutorizada(d1);
                    estado.setDataEnviada(d1);
                    estado.setDataGerada(d1);
                    estado.setModoOperacao(PropriedadesSistema.MODO_OP.NORMAL);
                    estado.setProtocoloXML(prot);
                    estado.setAssinada(true);
                    estado.setCnpj(((TNFe)nfe.getValue()).getInfNFe().getEmit().getCNPJ());
                    estado.setCnpjDestino(((TNFe)nfe.getValue()).getInfNFe().getDest().getCNPJ());
                    EntityTransaction t = this.daoTarget.getTransaction();
                    t.begin();
                    this.daoTarget.persist((Object)estado);
                    t.commit();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    private String extractXml(String xml) {
        int pos1 = xml.indexOf("<NFe");
        int pos2 = xml.indexOf("</NFe>");
        return xml.substring(pos1, pos2 + "</NFe>".length());
    }

    private String extractProt(String xml) {
        int pos1 = xml.indexOf("<protNF");
        int pos2 = xml.indexOf("</protNFe>");
        return xml.substring(pos1, pos2 + "</protNFe>".length());
    }

    public static void main(String[] args) {
        RestoreXML res = new RestoreXML();
        res.restore();
    }
}

