/*
 * Decompiled with CFR 0.152.
 */
package br.com.taragona.nfe.xmlwrapper;

import br.com.taragona.nfe.classes.recepcao.TNFe;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Vector;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

public class XMLFromDB {
    private EntityManager em;
    private EntityManagerFactory fac;
    private XMLGenerator xmls;
    private Class notaDB;
    private DAOGenerico dao;

    public XMLFromDB(String persistenceUnit, String className) {
        this.fac = Persistence.createEntityManagerFactory((String)persistenceUnit);
        this.em = this.fac.createEntityManager();
        this.xmls = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
        this.dao = new DAOGenerico(this.notaDB);
        try {
            this.notaDB = Class.class.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
    }

    private Collection obterElementos() {
        return this.dao.obterElementos();
    }

    private Object getValue(String name, Object obj) {
        Method[] methods;
        Method[] methodArray = methods = this.notaDB.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().contains(name) && method.getName().startsWith("get") && method.getParameterTypes().length == 0) {
                try {
                    return method.invoke(obj, new Object[0]);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++n2;
        }
        return null;
    }

    private TNFe convert(Object obj) {
        Method[] methods = TNFe.InfNFe.class.getDeclaredMethods();
        TNFe.InfNFe info = new TNFe.InfNFe();
        Method[] methodArray = methods;
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().startsWith("set") && method.getParameterTypes().length == 1) {
                try {
                    method.invoke((Object)info, this.getValue(method.getName().replace("set", ""), obj));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++n2;
        }
        TNFe nota = new TNFe();
        nota.setInfNFe(info);
        return nota;
    }

    public Collection<TNFe> convert() {
        Collection notas = this.obterElementos();
        Vector<TNFe> notasXML = new Vector<TNFe>();
        for (Object object : notas) {
            notasXML.add(this.convert(object));
        }
        return notasXML;
    }

    public void serializeToXML() {
        Collection<TNFe> notas = this.convert();
        for (TNFe nota : notas) {
            try {
                this.xmls.notaToXMLFile(nota, nota.getInfNFe().getId());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] argv) {
    }
}

