/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.sefaz.epec;

import br.com.taragona.nfe.classes.recepcao.TNFe;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EPECInfo;
import br.com.taragona.nfe.persistence.EntidadeId;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.tools.PathFileFinder;
import br.com.taragona.nfe.util.CodigoNFeManager;
import br.com.taragona.nfe.util.DelayTable;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.IDSetManager;
import br.com.taragona.nfe.util.PropriedadesSistema;
import br.com.taragona.nfe.util.UFTable;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import br.com.tti.sefaz.epec.xml.TEnvEvento;
import br.com.tti.sefaz.epec.xml.TEvento;
import br.com.tti.sefaz.epec.xml.TRetEnvEvento;
import br.com.tti.sefaz.epec.xml.TRetEvento;
import br.com.tti.sefaz.epec.xml.TUf;
import java.io.File;
import java.io.FileWriter;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.xml.bind.JAXBElement;

public class EPECEventGenerator {
    private DAOGenerico<EPECInfo> daoEpec = new DAOGenerico(EPECInfo.class);
    private SimpleDateFormat sdfnordeste;
    private SimpleDateFormat sdfcentral;
    private SimpleDateFormat sdfsemfuso;
    private DAOGenerico<EstadoNFe> daoxml = new DAOGenerico(EstadoNFe.class);
    private XMLGenerator gen = new XMLGenerator("br.com.tti.sefaz.epec.xml");
    private XMLGenerator genret = new XMLGenerator("br.com.tti.sefaz.epec.xml");
    private XMLGenerator xmlNFe;

    public EPECEventGenerator() {
        this.sdfnordeste = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:00'-03:00'");
        this.sdfcentral = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:00'-02:00'");
        this.sdfsemfuso = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:00");
        this.xmlNFe = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
    }

    public String adicionarEvento(String keyxml, String tpAmb, String xmlString, Hashtable<String, String> props, String idUsuario) throws RemoteException, Exception {
        TNFe nfe = (TNFe)((JAXBElement)this.xmlNFe.toObject(xmlString)).getValue();
        TEvento event = new TEvento();
        TEvento.InfEvento infevent = new TEvento.InfEvento();
        event.setInfEvento(infevent);
        TEvento.InfEvento.DetEvento detevent = new TEvento.InfEvento.DetEvento();
        GerenciadorChavesNota km = new GerenciadorChavesNota(keyxml);
        infevent.setDetEvento(detevent);
        infevent.setChNFe(keyxml.replace("NFe", ""));
        infevent.setCNPJ(km.getCnpj());
        infevent.setCOrgao("91");
        infevent.setTpEvento("110140");
        infevent.setVerEvento("1.00");
        infevent.setTpAmb(tpAmb);
        GerenciadorChavesNota c = new GerenciadorChavesNota(keyxml);
        detevent.setVersao("1.00");
        detevent.setDescEvento("EPEC");
        detevent.setCOrgaoAutor(c.getUF());
        detevent.setTpAutor("1");
        detevent.setVersao("1.00");
        detevent.setVerAplic(nfe.getInfNFe().getIde().getVerProc());
        detevent.setDhEmi(nfe.getInfNFe().getIde().getDhEmi());
        detevent.setTpNF(nfe.getInfNFe().getIde().getTpNF());
        detevent.setIE(nfe.getInfNFe().getEmit().getIE());
        TEvento.InfEvento.DetEvento.Dest dest = new TEvento.InfEvento.DetEvento.Dest();
        detevent.setDest(dest);
        dest.setUF(TUf.fromValue(nfe.getInfNFe().getDest().getEnderDest().getUF().toString()));
        dest.setCNPJ(nfe.getInfNFe().getDest().getCNPJ());
        dest.setCPF(nfe.getInfNFe().getDest().getCPF());
        if (dest.getCNPJ().isEmpty()) {
            dest.setCNPJ("12345678901234");
        }
        if (nfe.getInfNFe().getDest().getIE() != null && !nfe.getInfNFe().getDest().getIE().isEmpty()) {
            dest.setIE(nfe.getInfNFe().getDest().getIE());
        }
        dest.setVNF(nfe.getInfNFe().getTotal().getICMSTot().getVNF());
        dest.setVICMS(nfe.getInfNFe().getTotal().getICMSTot().getVICMS());
        dest.setVST(nfe.getInfNFe().getTotal().getICMSTot().getVST());
        EPECInfo info = new EPECInfo();
        info.setId(nfe.getInfNFe().getId());
        info.setAmbiente(tpAmb);
        info.setEvent(event);
        int nseqn = 1;
        info.setEstado(EstadoNFe.ESTADO_NFE.GERADA);
        info.setDataGerada(Calendar.getInstance().getTime());
        info.getEvent().getInfEvento().setNSeqEvento(String.valueOf(nseqn));
        info.getEvent().setVersao("1.00");
        long currentlonf = Calendar.getInstance().getTimeInMillis();
        Date currentdata = new Date(currentlonf);
        try {
            String delay = DelayTable.delay.getString(info.getEvent().getInfEvento().getCOrgao());
            if (delay.contains("+")) {
                delay = delay.replace("+", "");
                currentdata = new Date(currentlonf + (long)(Integer.parseInt(delay) * 60) * 1000L);
            } else {
                delay = delay.replace("-", "");
                currentdata = new Date(currentlonf - (long)(Integer.parseInt(delay) * 60) * 1000L);
            }
        }
        catch (Exception delay) {
            // empty catch block
        }
        String fusohorario = "-03:00";
        String dhevento = "";
        try {
            fusohorario = UFTable.fuso.getString(info.getEvent().getInfEvento().getCOrgao());
            dhevento = String.valueOf(this.sdfsemfuso.format(currentdata)) + fusohorario;
        }
        catch (Exception e) {
            System.out.println("nao foi possivel usar o arquivo fusohorario.properties");
            dhevento = info.getEvent().getInfEvento().getCOrgao().equals("42") || info.getEvent().getInfEvento().getCOrgao().equals("35") || info.getEvent().getInfEvento().getCOrgao().equals("33") || info.getEvent().getInfEvento().getCOrgao().equals("31") || info.getEvent().getInfEvento().getCOrgao().equals("32") || info.getEvent().getInfEvento().getCOrgao().equals("43") || info.getEvent().getInfEvento().getCOrgao().equals("53") || info.getEvent().getInfEvento().getCOrgao().equals("52") || info.getEvent().getInfEvento().getCOrgao().equals("41") || info.getEvent().getInfEvento().getCOrgao().equals("51") || info.getEvent().getInfEvento().getCOrgao().equals("50") ? this.sdfcentral.format(currentdata) : this.sdfnordeste.format(currentdata);
        }
        info.getEvent().getInfEvento().setDhEvento(dhevento);
        info.getEvent().getInfEvento().setTpAmb(tpAmb);
        String id = String.valueOf(info.getEvent().getInfEvento().getTpEvento()) + info.getEvent().getInfEvento().getChNFe() + "0" + info.getEvent().getInfEvento().getNSeqEvento();
        info.getEvent().setVersao("1.00");
        info.getEvent().getInfEvento().setId("ID" + id);
        String xmlCancelEvent = null;
        EntidadeId epecId = new EntidadeId(nfe.getInfNFe().getId(), nfe.getInfNFe().getIde().getTpAmb());
        if (this.daoEpec.buscarPorIdObject(epecId) == null) {
            this.daoEpec.salvar(info);
        } else {
            this.daoEpec.unir(info);
        }
        try {
            xmlCancelEvent = this.toXMLString(info);
            xmlCancelEvent = this.repareXML(info.getEvent().getInfEvento().getCNPJ(), xmlCancelEvent);
            FileWriter fw = new FileWriter("epec_evento.xml");
            fw.write(xmlCancelEvent);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        EntidadeId eid = new EntidadeId(keyxml, tpAmb);
        EstadoNFe xmlinfo = this.daoxml.buscarPorIdObject(eid);
        xmlinfo.setEstado(EstadoNFe.ESTADO_NFE.TENTANDO_ENVIO);
        try {
            GerenciadorProxy.gerenciador.atualizarNota(xmlinfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String resultxml = null;
        try {
            resultxml = GerenciadorProxy.enviarMensagemXML(PropriedadesSistema.ID_SERVICO_RECEPCAO_EVENTO, info.getEvent().getInfEvento().getCNPJ(), "", xmlCancelEvent, info.getEvent().getInfEvento().getCOrgao(), idUsuario);
        }
        catch (Exception e) {
            throw new RemoteException(e.getLocalizedMessage(), e.fillInStackTrace());
        }
        if (resultxml != null) {
            xmlinfo.setEstado(EstadoNFe.ESTADO_NFE.ENVIADA);
            try {
                GerenciadorProxy.gerenciador.atualizarNota(xmlinfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            info.setEstado(EstadoNFe.ESTADO_NFE.ENVIADA);
            info.setDataEnviada(Calendar.getInstance().getTime());
            info.setDataAtualizada(Calendar.getInstance().getTime());
            String rets = this.processResultXMLInfo(xmlinfo, info, resultxml, idUsuario);
            String endtag = "</retEnvEvento>";
            int pos1 = resultxml.indexOf("<retEnvEvento");
            int pos2 = resultxml.indexOf(endtag);
            if (pos1 != -1 && pos2 != -1) {
                resultxml = resultxml.substring(pos1, pos2 + endtag.length());
            }
            info.setXmlString(xmlCancelEvent);
            info.setProtocoloXML(resultxml);
            this.daoEpec.unir(info);
            this.daoEpec.flush();
            if (info.getEstado().equals((Object)EstadoNFe.ESTADO_NFE.AUTORIZADA)) {
                if (!keyxml.startsWith("NFe")) {
                    keyxml = "NFe" + keyxml;
                }
                xmlinfo.setEstado(EstadoNFe.ESTADO_NFE.EPEC_AUTORIZADO);
                xmlinfo.setProtocoloCancelamentoXML(resultxml);
                xmlinfo.setDataActualizada(Calendar.getInstance().getTime());
                xmlinfo.setEstadoNFe(101L);
                xmlinfo.setMotivoErro(info.getEvent().getInfEvento().getDhEvento());
                this.daoxml.unir(xmlinfo);
                this.daoxml.flush();
                try {
                    GerenciadorProxy.gerenciador.atualizarNota(xmlinfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                String pathcancel = PathFileFinder.getINSTANCE().findXMLEPECPath(keyxml, tpAmb, Calendar.getInstance().getTime());
                String epecfile = String.valueOf(pathcancel) + File.separator + keyxml + "_epec_prot.xml";
                String epecprot = this.extracXMLProt(info);
                try {
                    FileWriter fw = new FileWriter(epecfile);
                    fw.write(epecprot);
                    fw.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                if (!keyxml.startsWith("NFe")) {
                    keyxml = "NFe" + keyxml;
                }
                xmlinfo.setEstado(EstadoNFe.ESTADO_NFE.EPEC_REJEITADO);
                xmlinfo.setMotivoErro(info.getMensagem());
                try {
                    CodigoNFeManager.insereCodigo(Integer.valueOf(info.getCstat()), info.getMensagem());
                    xmlinfo.setEstadoNFe(Long.parseLong(info.getCstat()));
                }
                catch (Exception pathcancel) {
                    // empty catch block
                }
                try {
                    GerenciadorProxy.gerenciador.atualizarNota(xmlinfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return rets;
        }
        throw new RemoteException("Evento sem retorno da sefaz");
    }

    private String extracXMLProt(EPECInfo eventoinfo) {
        String stringxml = eventoinfo.getXmlString();
        String protocoloxml = eventoinfo.getProtocoloXML();
        String xml = "<procEventoNFe xmlns=\"http://www.portalfiscal.inf.br/nfe\" versao=\"1.00\">" + stringxml + protocoloxml + "</procEventoNFe>";
        return xml;
    }

    private String processResultXMLInfo(EstadoNFe xmlinfo, EPECInfo event, String xml, String idUsuario) {
        String endtag = "</retEnvEvento>";
        int pos1 = xml.indexOf("<retEnvEvento");
        int pos2 = xml.indexOf(endtag);
        if (pos1 != -1 && pos2 != -1) {
            xml = xml.substring(pos1, pos2 + endtag.length());
        }
        try {
            TRetEnvEvento ret = (TRetEnvEvento)this.genret.toObject(xml);
            String cstat = ret.getCStat();
            System.out.println(cstat);
            CodigoNFeManager.insereCodigo(Integer.valueOf(cstat), ret.getXMotivo());
            if (cstat.equals("128")) {
                List<TRetEvento> results = ret.getRetEvento();
                Iterator<TRetEvento> iterator = results.iterator();
                if (iterator.hasNext()) {
                    TRetEvento rett = iterator.next();
                    CodigoNFeManager.insereCodigo(Integer.valueOf(rett.getInfEvento().getCStat()), rett.getInfEvento().getXMotivo());
                    if (rett.getInfEvento().getCStat().equals("135") || rett.getInfEvento().getCStat().equals("136") || rett.getInfEvento().getCStat().equals("155")) {
                        event.setEstado(EstadoNFe.ESTADO_NFE.AUTORIZADA);
                        event.setDataAutorizada(Calendar.getInstance().getTime());
                        event.setDataAtualizada(Calendar.getInstance().getTime());
                        event.setCstat(rett.getInfEvento().getCStat());
                        event.setMensagem(rett.getInfEvento().getXMotivo());
                        event.getEvent().getInfEvento().setDhEvento(String.valueOf(rett.getInfEvento().getNProt()) + "|" + rett.getInfEvento().getDhRegEvento());
                        try {
                            GerenciadorProxy.gerenciador.reImprimirNota(xmlinfo.getId(), xmlinfo.getAmbiente(), idUsuario);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        event.setEstado(EstadoNFe.ESTADO_NFE.REJEITADA);
                        event.setMensagem(rett.getInfEvento().getXMotivo());
                        event.setDataAtualizada(Calendar.getInstance().getTime());
                        event.setCstat(rett.getInfEvento().getCStat());
                    }
                    System.out.println(event.getEstado().toString());
                    return String.valueOf(rett.getInfEvento().getCStat()) + ":" + rett.getInfEvento().getXMotivo();
                }
            } else {
                event.setEstado(EstadoNFe.ESTADO_NFE.ERRO);
                event.setMensagem(ret.getXMotivo());
                event.setDataAtualizada(Calendar.getInstance().getTime());
            }
            return String.valueOf(ret.getCStat()) + ":" + ret.getXMotivo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String repareXML(String cnpj, String xml) {
        FileWriter fw;
        try {
            fw = new FileWriter("epec_preassinado.xml");
            fw.write(xml);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        xml = xml.replace("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>", "");
        try {
            xml = GerenciadorProxy.gerenciador.assinar(cnpj, xml, "infEvento");
            xml = xml.replace("<envEvento versao=\"1.00\">", "<envEvento versao=\"1.00\" xmlns=\"http://www.portalfiscal.inf.br/nfe\">");
            fw = new FileWriter("epec_postpreassinado.xml");
            fw.write(xml);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return xml;
    }

    private String toXMLString(EPECInfo info) {
        TEnvEvento envevento = new TEnvEvento();
        envevento.setIdLote(IDSetManager.getNexIdSet().toString());
        envevento.getEvento().add(info.getEvent());
        envevento.setVersao("1.00");
        try {
            String xml = this.gen.toXMLString(envevento);
            return xml;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

