/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.sefaz.epec;

import br.com.taragona.nfe.mensageiro.contingencia.EstrategiaContingencia;
import br.com.taragona.nfe.persistence.DAOGenerico;
import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.taragona.nfe.util.GerenciadorProxy;
import br.com.taragona.nfe.util.PropriedadesSistema;
import java.rmi.RemoteException;
import java.util.List;
import javax.persistence.Query;

public class EstrategiaEPECImpl
implements EstrategiaContingencia {
    private String cnpj;
    private DAOGenerico<EstadoNFe> daoNota = new DAOGenerico(EstadoNFe.class);

    public EstrategiaEPECImpl(String cnpj) {
        this.cnpj = cnpj;
    }

    private String tirarAssinatura(String nota) {
        int i1 = nota.indexOf("<Signature");
        int i2 = nota.indexOf("</Signature>");
        if (i1 < 0 || i2 < 0) {
            return nota;
        }
        String assinatura = nota.substring(i1, i2 + "</Signature>".length());
        return nota.replace(assinatura, "");
    }

    @Override
    public void salirDeContingencia(String tpAmb, String idUsuario) {
        Query q = this.daoNota.criarQuery("select e from EstadoNFe as e where (e.estado = :estado1 and e.modoOperacao = :op) and e.cnpj = :cnpj and e.ambiente = :tpAmb");
        q.setParameter("estado1", (Object)EstadoNFe.ESTADO_NFE.EPEC_AUTORIZADO);
        q.setParameter("op", (Object)PropriedadesSistema.MODO_OP.CONTINGENCIA_EPEC);
        q.setParameter("cnpj", (Object)this.cnpj);
        q.setParameter("tpAmb", (Object)tpAmb);
        List notas = null;
        try {
            notas = q.getResultList();
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (EstadoNFe estadoNFe : notas) {
            this.daoNota.refresh(estadoNFe);
            String notaXML = estadoNFe.getXmlString();
            notaXML = this.tirarAssinatura(notaXML);
            try {
                GerenciadorProxy.getGerenciador().enviarNota(estadoNFe.getCnpj(), estadoNFe.getCnpjDestino(), estadoNFe.getId(), tpAmb, notaXML, estadoNFe.getDataActualizada(), idUsuario);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void entrarEmContingencia(String tpAmb) {
    }
}

