/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.ttinfe.printer;

import br.com.taragona.nfe.persistence.EstadoNFe;
import br.com.tti.sefaz.log.MyLogger;
import br.com.tti.sefaz.util.KeyXmlManager;
import br.com.tti.sefaz.util.MainParameters;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class PSGeneratorPrinter {
    public static int LINES_NUMBERS = 60;
    private PrintStream psstream;
    private File file;
    private int number = 1;
    private Hashtable<String, String> headerdata;
    private Vector<EstadoNFe> infos;
    private SimpleDateFormat dfh = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    private SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public PSGeneratorPrinter(Hashtable<String, String> headerdata, Vector<EstadoNFe> infos) {
        this.headerdata = headerdata;
        this.infos = infos;
        try {
            this.file = File.createTempFile("tmp_relatorio", ".ps");
            this.psstream = new PrintStream(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public File create() {
        this.startDocument();
        int counter = 0;
        int i = 0;
        int headerpos = 800;
        int linepos = 550;
        int pagenumber = 1;
        int totalpages = this.infos.size() / LINES_NUMBERS + 1;
        boolean firstpage = true;
        for (EstadoNFe info : this.infos) {
            if (counter % LINES_NUMBERS == 0) {
                if (!firstpage) {
                    this.psstream.append("showpage\n\n");
                    ++pagenumber;
                }
                this.createInitPage(pagenumber);
                this.fillHeader(headerpos, this.headerdata.get("dataconsulta"), String.valueOf(pagenumber), String.valueOf(totalpages), this.headerdata.get("emitente"), this.headerdata.get("destinatario"), this.headerdata.get("datainicio"), this.headerdata.get("datafim"));
                i = 0;
                counter = 0;
                firstpage = false;
            }
            this.fillLine(linepos - (i += 7), info);
            ++counter;
        }
        this.endDocument();
        return null;
    }

    private void startDocument() {
        this.toStream(this.psstream, this.readLocalResource("prologo.ps"));
        this.psstream.println("/consulta");
        this.psstream.println("<< /FormType 1");
        this.psstream.println("/BBox [ 0 0 842 842 ]");
        this.psstream.println("/Matrix [ 1 0 0 1 0 0 ]");
        this.psstream.println("/PaintProc");
        this.psstream.println("{ pop");
        this.toStream(this.psstream, this.readLocalResource("consulta.eps"));
        this.psstream.println("} bind");
        this.psstream.println(">> def");
        this.toStream(this.psstream, this.readLocalResource("consulta.prop"));
        this.psstream.println("%%EndProlog\n");
    }

    private void createInitPage(int number) {
        this.psstream.println("%%Page: " + number + " " + this.infos.size() / LINES_NUMBERS);
        this.psstream.println("orientacao_consulta_inicial");
        this.psstream.println("consulta_R_inicial_formulario");
    }

    private void fillHeader(float initpos, String dataconsulta, String paginanumero, String totalpagina, String emitente, String destinatario, String datainicio, String datafim) {
        this.psstream.println(" (" + dataconsulta + ") consulta_data_consulta");
        this.psstream.println(" (" + paginanumero + ") consulta_numero_pagina");
        this.psstream.println(" (" + totalpagina + ") consulta_total_pagina");
        this.psstream.println(" (" + emitente + ") consulta_emitente");
        this.psstream.println(" (" + destinatario + ") consulta_destinatario");
        this.psstream.println(" (" + datainicio + ") consulta_data_inicio");
        this.psstream.println(" (" + datafim + ") consulta_data_final");
    }

    private void fillLine(float initpos, EstadoNFe info) {
        String[] partes;
        KeyXmlManager key = new KeyXmlManager(info.getId());
        this.psstream.println(String.valueOf(initpos) + " (" + key.getSerie() + " - " + key.getNumeroNota() + ") consulta_numero_serie");
        String cnpjdestilong = info.getCnpjDestino();
        this.psstream.println(String.valueOf(initpos) + " (" + cnpjdestilong + ") consulta_cnpj");
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        this.psstream.println(String.valueOf(initpos) + " (" + sdf.format(info.getDataGerada()) + ") consulta_data_envio");
        String result = " ";
        try {
            result = info.getProtocolo();
            partes = result.split("\\|");
            result = this.dfh.format(this.sdf2.parse(partes[1]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result = result != null ? result.replace("null", "") : "";
        this.psstream.println(String.valueOf(initpos) + " (" + result + ") consulta_data_auto");
        result = " ";
        try {
            result = info.getProtocolo();
            partes = result.split("\\|");
            result = partes[0];
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result = result != null ? result.replace("null", "") : "";
        this.psstream.println(String.valueOf(initpos) + " (" + result + ") consulta_protocolo");
        this.psstream.println(String.valueOf(initpos) + " (" + info.getEstado().toString().replace("_SEMXML", "") + ") consulta_estado");
    }

    private void endDocument() {
        this.psstream.append("showpage\n");
        this.toStream(this.psstream, this.readLocalResource("epilogo.ps"));
        this.psstream.close();
    }

    private ArrayList<String> readLocalResource(String arquivo) {
        String linha = null;
        ArrayList<String> lista = new ArrayList<String>();
        InputStream is = PSGeneratorPrinter.class.getResourceAsStream("resources/" + arquivo);
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        try {
            while ((linha = br.readLine()) != null) {
                lista.add(linha);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            br.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        try {
            is.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return lista;
    }

    public File generatePDF() {
        try {
            File fileout = File.createTempFile("relatorio", ".pdf");
            Runtime r = Runtime.getRuntime();
            String command = String.valueOf(MainParameters.getPfx()) + " " + this.file.getAbsolutePath() + " " + fileout.getAbsolutePath();
            MyLogger.getLog().info("DOS Command ps2pdf:" + command);
            r.exec(command);
            return fileout;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void toStream(PrintStream fo, ArrayList<String> lista) {
        for (String linha : lista) {
            fo.println(linha);
        }
    }
}

