/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.util;

import br.com.taragona.nfe.classes.recepcao.TNFe;
import br.com.taragona.nfe.danfe.ImprimirDANFEImpl;
import br.com.taragona.nfe.util.GerenciadorChavesNota;
import br.com.taragona.nfe.util.PropriedadesMain;
import br.com.taragona.nfe.util.logger.MyLogger;
import br.com.taragona.nfe.xmlgenerator.XMLGenerator;
import br.com.tti.util.CopyFile;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.xml.bind.JAXBElement;

public class Clasificator {
    private static int TRIES = 3;
    private SimpleDateFormat df;
    private ResourceBundle bundle;
    private XMLGenerator xmls;
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private int DAYS;

    public Clasificator() {
        this.df = new SimpleDateFormat("dd-mm-yyyy");
        this.bundle = ResourceBundle.getBundle("pasta_cnpj_backup");
        this.xmls = new XMLGenerator("br.com.taragona.nfe.classes.recepcao");
        this.DAYS = Integer.parseInt(this.bundle.getString("dias"));
    }

    private String findDir(String id) {
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String dir = String.valueOf(chave.getCnpj()) + "_20" + chave.getDdmm();
        String cnpjEmit = chave.getCnpj();
        String root = this.bundle.getString("destino");
        String path = String.valueOf(root) + "\\" + dir;
        File f = new File(path);
        if (!f.exists()) {
            f.mkdir();
        }
        return f.getAbsolutePath();
    }

    private String createFileName(String id) {
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String filename = "NFe_" + chave.getCnpj() + "_" + Integer.parseInt(chave.getSerie()) + "_" + Integer.parseInt(chave.getNumeroNota()) + ".xml";
        return filename;
    }

    private String locateFile(String id) {
        GerenciadorChavesNota chave = new GerenciadorChavesNota(id);
        String dir = String.valueOf(chave.getCnpj()) + "_20" + chave.getDdmm();
        String root = this.bundle.getString("destino");
        String path = String.valueOf(root) + "\\" + dir;
        String filename = this.createFileName(id);
        File f = new File(path = String.valueOf(path) + "\\" + filename);
        if (f.exists()) {
            return f.getAbsolutePath();
        }
        return null;
    }

    public String readXMLFile(String id) {
        String file = this.locateFile(id);
        System.out.println("Procurando no Storage:" + file);
        String xml = ImprimirDANFEImpl.lerArquivo(file);
        return xml;
    }

    public void writeXMLFile(String id, String xml) {
        String file = this.locateFile(id);
        String filename = this.createFileName(id);
        String path = String.valueOf(file) + "\\" + filename;
        try {
            FileWriter fw = new FileWriter(path);
            fw.write(xml);
            fw.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void removePDF(File dir, String id) {
        if (!dir.exists()) {
            MyLogger.getLogger().info("Pasta nao existe:" + dir.getAbsolutePath());
            return;
        }
        File pdf = new File(String.valueOf(dir.getAbsolutePath()) + "\\" + id + ".pdf");
        this.removeFile(pdf.getAbsolutePath());
    }

    private void removePDF(File dir) {
        if (!dir.exists()) {
            MyLogger.getLogger().info("Pasta nao existe:" + dir.getAbsolutePath());
            return;
        }
        File[] pdfs = dir.listFiles();
        if (pdfs == null) {
            return;
        }
        File[] fileArray = pdfs;
        int n = pdfs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getAbsolutePath().endsWith(".pdf")) {
                this.removeFile(f.getAbsolutePath());
            }
            ++n2;
        }
    }

    private void removePS(File dir) {
        if (!dir.exists()) {
            MyLogger.getLogger().info("Pasta nao existe:" + dir.getAbsolutePath());
            return;
        }
        File[] pdfs = dir.listFiles();
        if (pdfs == null) {
            return;
        }
        File[] fileArray = pdfs;
        int n = pdfs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getAbsolutePath().endsWith(".ps")) {
                this.removeFile(f.getAbsolutePath());
            }
            ++n2;
        }
    }

    private void removeTXT(File dir) {
        if (!dir.exists()) {
            MyLogger.getLogger().info("Pasta nao existe:" + dir.getAbsolutePath());
            return;
        }
        File[] pdfs = dir.listFiles();
        if (pdfs == null) {
            return;
        }
        File[] fileArray = pdfs;
        int n = pdfs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.getAbsolutePath().endsWith(".txt") || f.getAbsolutePath().endsWith(".TXT")) {
                this.removeFile(f.getAbsolutePath());
            }
            ++n2;
        }
    }

    private File protName(String filename) {
        String prot = filename.replace(".xml", "_prot.xml");
        File f = new File(prot);
        if (!f.exists()) {
            return null;
        }
        return f;
    }

    private File protName(String filename, String cnpj, String serie, String numero) {
        filename = filename.replace("\\", "/");
        String[] paths = filename.split("/");
        String allpath = "";
        int i = 0;
        while (i < paths.length - 1) {
            allpath = String.valueOf(allpath) + paths[i] + "\\";
            ++i;
        }
        DecimalFormat fserie = new DecimalFormat("000");
        DecimalFormat fnn = new DecimalFormat("000000000");
        File f = new File(allpath = String.valueOf(allpath) + "NFe_" + cnpj + "_" + Integer.parseInt(serie) + "_" + fnn.format(Integer.parseInt(numero)) + "_prot.xml");
        if (!f.exists()) {
            return null;
        }
        return f;
    }

    private boolean checkData(String dataEmiss) {
        try {
            Date de = this.sdf.parse(dataEmiss);
            long current = Calendar.getInstance().getTimeInMillis();
            long days = this.DAYS * 24 * 60 * 60 * 1000;
            Date limit = new Date(current - days);
            System.out.println(limit);
            System.out.println(de);
            System.out.println("return?" + de.before(limit));
            return de.before(limit);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void moveXML(File dirSource) {
        File[] files;
        MyLogger.getLogger().info("Scanning diretorio:" + dirSource.getAbsolutePath());
        File[] fileArray = files = dirSource.listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File xmlSource = fileArray[n2];
            if (xmlSource.getAbsolutePath().endsWith(".xml") && !xmlSource.getAbsolutePath().contains("prot")) {
                MyLogger.getLogger().info("Lendo arquivo:" + xmlSource.getAbsolutePath());
                try {
                    String xml = ImprimirDANFEImpl.lerArquivo(xmlSource.getAbsolutePath());
                    TNFe xmle = (TNFe)((JAXBElement)this.xmls.toObject(xml)).getValue();
                    String de = xmle.getInfNFe().getIde().getDEmi().toString();
                    if (this.checkData(de)) {
                        File xmlProtSource = this.protName(xmlSource.getAbsolutePath(), xmle.getInfNFe().getEmit().getCNPJ(), xmle.getInfNFe().getIde().getSerie(), xmle.getInfNFe().getIde().getNNF());
                        String dirContainer = this.findDir(xmle.getInfNFe().getId());
                        String destXml = String.valueOf(dirContainer) + "\\" + xmlSource.getName();
                        CopyFile.copyfile(xmlSource.getAbsolutePath(), destXml);
                        this.removeFile(xmlSource.getAbsolutePath());
                        if (xmlProtSource != null) {
                            String destXmlProt = String.valueOf(dirContainer) + "\\" + xmlProtSource.getName();
                            CopyFile.copyfile(xmlProtSource.getAbsolutePath(), destXmlProt);
                            this.removeFile(xmlProtSource.getAbsolutePath());
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
    }

    public void visit(File root) {
        File[] dirs;
        File[] fileArray = dirs = root.listFiles();
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            File dir = fileArray[n2];
            File pdfdir = new File(String.valueOf(dir.getAbsolutePath()) + "\\PDF");
            File psdir = new File(String.valueOf(dir.getAbsolutePath()) + "\\PS");
            File xmldir = new File(String.valueOf(dir.getAbsolutePath()) + "\\XML");
            this.removePDF(pdfdir);
            this.removePS(psdir);
            this.removeTXT(xmldir);
            this.moveXML(xmldir);
            ++n2;
        }
    }

    private void removeFile(String path) {
        File f = new File(path);
        boolean remove = true;
        int i = 0;
        while (i < TRIES) {
            remove = f.delete();
            if (remove) {
                MyLogger.getLogger().info("Arquivo removido:" + f.getAbsolutePath());
                return;
            }
            ++i;
        }
    }

    public void make() {
        PropriedadesMain.setUtf(true);
        String root = this.bundle.getString("origem");
        File f = new File(root);
        this.visit(f);
    }

    public static void main(String[] args) {
        Clasificator c = new Clasificator();
        c.make();
    }
}

