/*
 * Decompiled with CFR 0.152.
 */
package br.com.tti.util;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class PdfReadyChecker {
    private PdfReadyChecker() {
    }

    public static Result waitUntilReady(Path pdf, Config cfg) throws InterruptedException {
        Objects.requireNonNull(pdf, "pdf");
        Objects.requireNonNull(cfg, "cfg");
        long start = System.currentTimeMillis();
        long lastSize = -1L;
        FileTime lastMtime = null;
        long stableSince = -1L;
        int i = 0;
        while (i < cfg.maxPolls || cfg.hardTimeoutMillis > 0L) {
            block19: {
                if (cfg.hardTimeoutMillis > 0L && System.currentTimeMillis() - start > cfg.hardTimeoutMillis) {
                    return new Result(false, "timeout (hard timeout exceeded)");
                }
                if (!Files.exists(pdf, new LinkOption[0])) {
                    Thread.sleep(cfg.pollSleepMillis);
                } else {
                    boolean stableNow;
                    FileTime mtime;
                    long size;
                    try {
                        size = Files.size(pdf);
                        mtime = Files.getLastModifiedTime(pdf, new LinkOption[0]);
                    }
                    catch (IOException ioe) {
                        Thread.sleep(cfg.pollSleepMillis);
                        break block19;
                    }
                    boolean bl = stableNow = size > 0L && size == lastSize && lastMtime != null && mtime != null && mtime.toMillis() == lastMtime.toMillis();
                    if (!stableNow) {
                        stableSince = System.currentTimeMillis();
                        lastSize = size;
                        lastMtime = mtime;
                        Thread.sleep(cfg.pollSleepMillis);
                    } else {
                        long stableElapsed;
                        if (stableSince < 0L) {
                            stableSince = System.currentTimeMillis();
                        }
                        if ((stableElapsed = System.currentTimeMillis() - stableSince) < cfg.minStableMillis) {
                            Thread.sleep(cfg.pollSleepMillis);
                        } else if (size < cfg.minFileSizeBytes) {
                            Thread.sleep(cfg.pollSleepMillis);
                        } else if (cfg.trySharedLock && !PdfReadyChecker.isFreeForSharedRead(pdf)) {
                            Thread.sleep(cfg.pollSleepMillis);
                        } else if (cfg.checkPdfEof && !PdfReadyChecker.hasPdfEof(pdf, cfg.eofScanTailBytes)) {
                            Thread.sleep(cfg.pollSleepMillis);
                        } else if (cfg.tryPdfBoxOpen && !PdfReadyChecker.canOpenWithPdfBox(pdf, cfg.pdfBoxMinPages)) {
                            Thread.sleep(cfg.pollSleepMillis);
                        } else {
                            return new Result(true, "ok");
                        }
                    }
                }
            }
            ++i;
        }
        return new Result(false, "timeout (polls exhausted)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasPdfEof(Path pdf, int tailBytes) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (RandomAccessFile raf = new RandomAccessFile(pdf.toFile(), "r");){
                long len = raf.length();
                if (len <= 0L) {
                    return false;
                }
                int read = (int)Math.min(len, (long)Math.max(512, tailBytes));
                byte[] buf = new byte[read];
                raf.seek(len - (long)read);
                raf.readFully(buf);
                String s = new String(buf, StandardCharsets.ISO_8859_1);
                return s.contains("%%EOF");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * Loose catch block
     */
    public static boolean isFreeForSharedRead(Path pdf) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileChannel ch = FileChannel.open(pdf, StandardOpenOption.READ);){
                boolean bl;
                FileLock lock;
                Throwable throwable2;
                block21: {
                    throwable2 = null;
                    Object var5_9 = null;
                    lock = ch.tryLock(0L, Long.MAX_VALUE, true);
                    bl = lock != null;
                    if (lock == null) break block21;
                    lock.close();
                }
                return bl;
                {
                    catch (Throwable throwable3) {
                        try {
                            if (lock != null) {
                                lock.close();
                            }
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                            } else if (throwable2 != throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            throw throwable2;
                        }
                    }
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                } else if (throwable != throwable5) {
                    throwable.addSuppressed(throwable5);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean canOpenWithPdfBox(Path pdf, int minPages) {
        boolean bl;
        Class<?> pdDoc = Class.forName("org.apache.pdfbox.pdmodel.PDDocument");
        Method load = pdDoc.getMethod("load", File.class);
        Object doc = load.invoke(null, pdf.toFile());
        try {
            Method getPages = pdDoc.getMethod("getNumberOfPages", new Class[0]);
            int pages = (Integer)getPages.invoke(doc, new Object[0]);
            bl = pages >= Math.max(1, minPages);
        }
        catch (Throwable throwable) {
            try {
                try {
                    pdDoc.getMethod("close", new Class[0]).invoke(doc, new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (ClassNotFoundException e) {
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        try {
            pdDoc.getMethod("close", new Class[0]).invoke(doc, new Object[0]);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    public static boolean waitReady(Path pdf, long timeoutSeconds) throws InterruptedException {
        Config cfg = new Config();
        long polls = Math.max(1L, timeoutSeconds * 1000L / cfg.pollSleepMillis);
        cfg.maxPolls = (int)Math.min(Integer.MAX_VALUE, polls);
        return PdfReadyChecker.waitUntilReady((Path)pdf, (Config)cfg).ready;
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("uso: PdfReadyChecker <arquivo.pdf>");
            System.exit(1);
        }
        Path p = Paths.get(args[0], new String[0]);
        Config cfg = new Config();
        cfg.minStableMillis = 1500L;
        cfg.checkPdfEof = true;
        cfg.trySharedLock = true;
        cfg.tryPdfBoxOpen = false;
        cfg.hardTimeoutMillis = TimeUnit.SECONDS.toMillis(60L);
        Result r = PdfReadyChecker.waitUntilReady(p, cfg);
        System.out.println(r);
        System.exit(r.ready ? 0 : 2);
    }

    public static final class Config {
        public long minStableMillis = 1500L;
        public int maxPolls = 40;
        public long pollSleepMillis = 250L;
        public boolean checkPdfEof = true;
        public int eofScanTailBytes = 2048;
        public boolean trySharedLock = false;
        public boolean tryPdfBoxOpen = false;
        public int pdfBoxMinPages = 1;
        public long minFileSizeBytes = 256L;
        public long hardTimeoutMillis = 0L;
    }

    public static final class Result {
        public final boolean ready;
        public final String reason;

        public Result(boolean ready, String reason) {
            this.ready = ready;
            this.reason = reason;
        }

        public String toString() {
            return "PdfReadyChecker.Result{ready=" + this.ready + ", reason='" + this.reason + "'}";
        }
    }
}

