ALTER TABLE EstadoNFe DROP PRIMARY KEY;
ALTER TABLE EstadoNFeOld DROP PRIMARY KEY;
ALTER TABLE EstadoNFe DROP FOREIGN KEY FK_ESTADONFE_LOTE_ID;
ALTER TABLE EstadoNFeOld DROP FOREIGN KEY FK_ESTADONFEOLD_LOTE_ID;
ALTER TABLE EstadoLote DROP PRIMARY KEY;
ALTER TABLE ExtraXMLInfo DROP PRIMARY KEY;
ALTER TABLE EstadoRecibo DROP PRIMARY KEY;
ALTER TABLE EPECInfo DROP PRIMARY KEY;
ALTER TABLE XMLBoleto DROP PRIMARY KEY;
ALTER TABLE Empresa DROP PRIMARY KEY;
ALTER TABLE EmpresaLFU DROP PRIMARY KEY;
ALTER TABLE Usuario DROP FOREIGN KEY FK_USUARIO_PERFIL_ID ;

-- Verifica as chaves estrangeiras
SELECT
    kcu.TABLE_NAME,
    kcu.COLUMN_NAME,
    kcu.CONSTRAINT_NAME,
    kcu.REFERENCED_TABLE_NAME,
    kcu.REFERENCED_COLUMN_NAME
FROM information_schema.KEY_COLUMN_USAGE kcu
WHERE kcu.TABLE_SCHEMA = 'httinfe'
  AND (
       kcu.TABLE_NAME = 'EstadoLote'              -- FKs dentro da prpria tabela
    OR kcu.REFERENCED_TABLE_NAME = 'EstadoLote'   -- FKs de outras tabelas apontando pra ela
  );

ALTER TABLE CadastroEmail MODIFY COLUMN ID bigint(20) auto_increment NOT NULL;
ALTER TABLE EPECInfo MODIFY COLUMN ID bigint(20) auto_increment NOT NULL;
ALTER TABLE EstadoNFeOld MODIFY COLUMN ID int(11) auto_increment NOT NULL;
ALTER TABLE EventoInfo MODIFY COLUMN ID int(11) auto_increment NOT NULL;
ALTER TABLE LogEnvioEmail MODIFY COLUMN ID int(11) auto_increment NOT NULL;
ALTER TABLE LogNFe MODIFY COLUMN ID bigint(20) auto_increment NOT NULL;
ALTER TABLE MensageiroParametros MODIFY COLUMN ID int(11) auto_increment NOT NULL;
ALTER TABLE Notificacao MODIFY COLUMN ID int(11) auto_increment NOT NULL;
ALTER TABLE Propriedades MODIFY COLUMN ID int(11) auto_increment NOT NULL;
ALTER TABLE Perfil MODIFY COLUMN ID bigint(20) auto_increment NOT NULL;

ALTER TABLE EstadoNFe ADD COLUMN AMBIENTE VARCHAR(1) NOT NULL DEFAULT '1';
ALTER TABLE EPECInfo ADD COLUMN AMBIENTE VARCHAR(1) NOT NULL DEFAULT '1';
ALTER TABLE EstadoNFeOld ADD COLUMN AMBIENTE VARCHAR(1) NOT NULL DEFAULT '1';
ALTER TABLE EstadoLote ADD COLUMN AMBIENTE VARCHAR(1) NOT NULL DEFAULT '1';
ALTER TABLE EstadoRecibo ADD COLUMN AMBIENTE VARCHAR(1) NOT NULL DEFAULT '1';
ALTER TABLE LogEnvioEmail ADD COLUMN AMBIENTE VARCHAR(1) NOT NULL DEFAULT '1';
ALTER TABLE LogNFe ADD COLUMN AMBIENTE VARCHAR(1) NOT NULL DEFAULT '1';
ALTER TABLE ExtraXMLInfo ADD COLUMN AMBIENTE VARCHAR(1) NOT NULL DEFAULT '1';
ALTER TABLE XMLBOLETO ADD COLUMN AMBIENTE VARCHAR(1) NOT NULL DEFAULT '1';
ALTER TABLE Empresa ADD COLUMN AMBIENTE VARCHAR(1) NOT NULL DEFAULT '1';
ALTER TABLE EmpresaLFU ADD COLUMN AMBIENTE VARCHAR(1) NOT NULL DEFAULT '1';

ALTER TABLE EstadoNFe ADD PRIMARY KEY (ID, AMBIENTE);
ALTER TABLE EstadoNFeOld ADD PRIMARY KEY (ID, AMBIENTE);
ALTER TABLE EstadoLote ADD PRIMARY KEY (ID, AMBIENTE);
ALTER TABLE ExtraXMLInfo ADD PRIMARY KEY (ID, AMBIENTE);
ALTER TABLE EstadoRecibo ADD PRIMARY KEY (ID, AMBIENTE);
ALTER TABLE EPECInfo ADD PRIMARY KEY (ID, AMBIENTE);
ALTER TABLE XMLBOLETO ADD PRIMARY KEY (CHAVENFE, AMBIENTE);
ALTER TABLE Empresa ADD PRIMARY KEY (CNPJ, AMBIENTE);
ALTER TABLE EmpresaLFU ADD PRIMARY KEY (LOGIN, AMBIENTE);
ALTER TABLE usuario ADD CONSTRAINT FK_USUARIO_PERFIL_ID FOREIGN KEY (perfil_id) REFERENCES perfil(id);

UPDATE EstadoNFe SET ambiente='2';
UPDATE EPECInfo SET ambiente='2';
UPDATE EstadoNFeOld SET ambiente='2';
UPDATE EstadoLote SET ambiente='2';
UPDATE EstadoRecibo SET ambiente='2';
UPDATE LogEnvioEmail SET ambiente='2';
UPDATE LogNFe SET ambiente='2';
UPDATE ExtraXMLInfo SET ambiente='2';
UPDATE XMLBOLETO SET ambiente='2';
UPDATE Empresa SET ambiente='2';
UPDATE EmpresaLFU SET ambiente='2';

CREATE INDEX lognfe_idx1 ON lognfe(idnota, ambiente);
CREATE INDEX eventoinfo_idx1 ON eventoinfo(chnfe, tpamb);

-- usado para monitorar os boletos
CREATE INDEX idx_estado_boleto
      ON EstadoNFe (GEROUBOLETO, IMPORTOUBOLETO, AMBIENTE, CNPJ, DATAGERADA);

-- Atualiza o novo campo ambiente
UPDATE EstadoNFe
   SET ambiente=TRIM(SUBSTRING_INDEX(SUBSTRING_INDEX(xmlString, '<tpAmb>', -1), '</tpAmb>', 1))
 WHERE ambiente = ''
   AND SUBSTRING_INDEX(xmlString, '<tpAmb>', -1) > 0;

UPDATE EstadoNFeOld
   SET ambiente=TRIM(SUBSTRING_INDEX(SUBSTRING_INDEX(xmlString, '<tpAmb>', -1), '</tpAmb>', 1))
 WHERE ambiente = ''
   AND SUBSTRING_INDEX(xmlString, '<tpAmb>', -1) > 0;

UPDATE EstadoLote el
   SET el.ambiente=(SELECT max(e.ambiente)
                      FROM EstadoNFe e
                     WHERE e.lote_id=el.id)
 WHERE (SELECT max(e.ambiente)
          FROM EstadoNFe e
         WHERE e.lote_id=el.id) IS NOT NULL;

UPDATE LogNFe l
   SET l.ambiente=(SELECT max(e.ambiente)
                      FROM EstadoNFe e
                     WHERE e.id=l.idNota)
 WHERE (SELECT max(e.ambiente)
          FROM EstadoNFe e
         WHERE e.lote_id=l.id) IS NOT NULL;

UPDATE ExtraXMLInfo
   SET ambiente=TRIM(SUBSTRING_INDEX(SUBSTRING_INDEX(xmlString, '<tpAmb>', -1), '</tpAmb>', 1))
 WHERE ambiente = ''
   AND SUBSTRING_INDEX(xmlString, '<tpAmb>', -1) > 0;

UPDATE EstadoRecibo
   SET ambiente=TRIM(SUBSTRING_INDEX(SUBSTRING_INDEX(xmlString, '<tpAmb>', -1), '</tpAmb>', 1))
 WHERE ambiente = ''
   AND SUBSTRING_INDEX(xmlString, '<tpAmb>', -1) > 0;

UPDATE EPECInfo
   SET ambiente=TRIM(SUBSTRING_INDEX(SUBSTRING_INDEX(xmlString, '<tpAmb>', -1), '</tpAmb>', 1))
 WHERE ambiente = ''
   AND SUBSTRING_INDEX(xmlString, '<tpAmb>', -1) > 0;

UPDATE XMLBoleto
   SET ambiente=TRIM(SUBSTRING_INDEX(SUBSTRING_INDEX(xmlBoleto, '<tpAmb>', -1), '</tpAmb>', 1))
 WHERE ambiente = ''
   AND SUBSTRING_INDEX(xmlBoleto, '<tpAmb>', -1) > 0;

-- Atualiza outros
UPDATE EstadoNFe
   SET outros = motivoErro
 WHERE outros IS NULL OR outros = ''
 AND (
      motivoErro LIKE 'Site|%'           OR
      motivoErro LIKE 'UNILOG|%'         OR
      motivoErro LIKE 'OLIST|%'          OR
      motivoErro LIKE 'ANYM%'            OR
      motivoErro LIKE 'INFR%'            OR
      motivoErro LIKE 'MINIDANFE%'
     );
