ALTER TABLE EstadoNFe      DROP PRIMARY KEY;
ALTER TABLE EstadoNFeOld   DROP PRIMARY KEY;
ALTER TABLE EstadoNFe      DROP CONSTRAINT FK_ESTADONFE_LOTE_ID;
ALTER TABLE EstadoNFeOld   DROP CONSTRAINT FK_ESTADONFEOLD_LOTE_ID;
ALTER TABLE EstadoLote     DROP PRIMARY KEY;
ALTER TABLE ExtraXMLInfo   DROP PRIMARY KEY;
ALTER TABLE EstadoRecibo   DROP PRIMARY KEY;
ALTER TABLE EPECInfo       DROP PRIMARY KEY;
ALTER TABLE XMLBoleto      DROP PRIMARY KEY;
ALTER TABLE Empresa        DROP PRIMARY KEY;
ALTER TABLE EmpresaLFU     DROP PRIMARY KEY;
ALTER TABLE Usuario        DROP CONSTRAINT FK_USUARIO_PERFIL_ID;

UPDATE EstadoNFe SET ambiente='2';
UPDATE EPECInfo SET ambiente='2';
UPDATE EstadoNFeOld SET ambiente='2';
UPDATE EstadoLote SET ambiente='2';
UPDATE EstadoRecibo SET ambiente='2';
UPDATE LogEnvioEmail SET ambiente='2';
UPDATE LogNFe SET ambiente='2';
UPDATE ExtraXMLInfo SET ambiente='2';
UPDATE XMLBOLETO SET ambiente='2';
UPDATE Empresa SET ambiente='2';
UPDATE EmpresaLFU SET ambiente='2';

ALTER TABLE EstadoNFe
  ADD CONSTRAINT PK_ESTADONFE
  PRIMARY KEY (ID, AMBIENTE);

ALTER TABLE EstadoNFeOld
  ADD CONSTRAINT PK_ESTADONFEOLD
  PRIMARY KEY (ID, AMBIENTE);

ALTER TABLE EstadoLote
  ADD CONSTRAINT PK_ESTADOLote
  PRIMARY KEY (ID, AMBIENTE);

ALTER TABLE ExtraXMLInfo
  ADD CONSTRAINT PK_EXTRAXMLINFO
  PRIMARY KEY (ID, AMBIENTE);

ALTER TABLE EstadoRecibo
  ADD CONSTRAINT PK_ESTADORECIBO
  PRIMARY KEY (ID, AMBIENTE);

ALTER TABLE EPECInfo
  ADD CONSTRAINT PK_EPECINFO
  PRIMARY KEY (ID, AMBIENTE);

ALTER TABLE XMLBOLETO
  ADD CONSTRAINT PK_XMLBOLETO
  PRIMARY KEY (CHAVENFE, AMBIENTE);

ALTER TABLE Empresa
  ADD CONSTRAINT PK_EMPRESA
  PRIMARY KEY (CNPJ, AMBIENTE);

ALTER TABLE EmpresaLFU
  ADD CONSTRAINT PK_EMPRESALFU
  PRIMARY KEY (LOGIN, AMBIENTE);

ALTER TABLE Usuario
  ADD CONSTRAINT FK_USUARIO_PERFIL_ID
  FOREIGN KEY (PERFIL_ID)
  REFERENCES Perfil(ID);

CREATE INDEX LOGNFE_IDX1
    ON LOGNFE (IDNOTA, AMBIENTE);

CREATE INDEX EVENTOINFO_IDX1
    ON EVENTOINFO (CHNFE, TPAMB);
